// CRollupCtrl & CRollupHeader
// (c) 2002 by FoRcHa (a.k.a. NO)  [seppforcher38@hotmail.com]
//
// I would appreciate a notification of any bugs or bug fixes to help the control grow.
///////////////////////////////////////////////////////////////////////////////////////////
#pragma once

#define USRMSG_GRIPPERMOVE	WM_USER + 2

#define RUP_GRIPPERWIDTH	60
#define RUP_GRIPPERHEIGHT	10

#define GRIPPER_STATE_NORMAL	0
#define GRIPPER_STATE_MOUSEOVER	1
#define GRIPPER_STATE_PRESSED	2

#define GRIPPER_ROWCOUNT	2


class CRollupGripper : public CWnd
{
	DECLARE_DYNAMIC(CRollupGripper)

public:
	CRollupGripper();
	virtual ~CRollupGripper();

	int GetLastMove() const		{ return m_iLastMove; }

	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnCancelMode();

protected:
	CPoint m_cpLastPoint;
	CDC		MemDC;
	CBitmap	MemBMP;
	CBitmap *pOldMemBMP;

	int	m_iState;
	int m_iLastMove;

	bool	m_bMouseOver;
	bool	m_bLButtonDown;
	bool	m_bInit;

protected:
	void DrawDot(CDC *pDC, int x, int y, COLORREF hicolor, COLORREF locolor, bool invert = FALSE);
	COLORREF LightenColor(COLORREF crColor, int i);

	DECLARE_MESSAGE_MAP()
};

// (p) 2002 by FoRcHa (a.k.a. NO)  [seppforcher38@hotmail.com]
